%% This file is `GUILAN-style.cls', by Mohsen Masoudi
%% This style tested by TexLive 2013-2020.
\usepackage[left=3cm,right=3cm,bottom=2cm,top=2.5cm]{geometry} % بسته‌ای برای تنظیم اندازه صفحه پایان‌نامه. در صورتیکه از این فایل برای تهیه کتاب استفاده شود، باید در جلوی این دسستور علامت درصد گذاشته شود. 
\usepackage[usenames,dvipsnames,x11names]{xcolor}
\usepackage{tabu,cite,bookmark,tocbibind,listings,moreverb,xcolor,colortbl,multirow,rotating,showexpl}
\usepackage{enumerate,framed,graphicx,graphics,algorithm,algorithmic,varwidth, pifont}
\usepackage{amsthm,amssymb,amsmath,amsfonts,amscd,latexsym,fancyhdr,multirow,float} 
\usepackage{fancybox} 
\usepackage[all]{xy}
\usepackage{roundbox}
\usepackage{subfigure}
\usepackage[subfigure]{tocloft}
\usepackage{hyperref}
\hypersetup{colorlinks=true,linkcolor=blue, anchorcolor=green, citecolor=magenta, urlcolor=cyan, filecolor=magenta}

\usepackage[xindy]{glossaries}

\usepackage{setspace}
%\onehalfspacing
% در مورد تقدم و تاخر وارد کردن بسته ها تنها باید به چند نکته دقت کرد:
% الف) بسته xepersian حتما حتما باید آخرین بسته ای باشد که فراخوانی می شود
% ب) بسته hyperref جزو آخرین بسته هایی باید باشد که فراخوانی می شود.
% ج) بسته glossaries حتما باید بعد از hyperref فراخوانی شود. 


\usepackage{tikz,pgfplots}%
\pgfplotsset{compat=1.14}
\usetikzlibrary{calc,shadows}
\usepackage[extrafootnotefeatures]{xepersian}
\twocolumnfootnotes % دستور برای دوستونه کردن پاورقی 
% \threecolumnfootnotes % برای سه ستونه کردن
\usepackage{zref-perpage}
\zmakeperpage{footnote}
\makeatletter
\@bidi@removefromreset{footnote}{chapter}
\makeatother 
\usepackage{ xepersian}

%%با تغییراتی که در فونت XB Niloofar ایجاد شده و به همراه این فایل می‌باشد، این فونت دارای صفر توخالی است. 
\settextfont[Scale=1, SmallCapsFont={XB Niloofar}]{XB Niloofar} %%% تنظیم اندازه و فونت متن فارسی 
%\setlatintextfont[Scale=.9, SmallCapsFont={XB Niloofar}]{XB Niloofar} %%% تنظیم اندازه و فونت متن فارسی 

\setdigitfont[Scale=1]{XB Niloofar} % تنظیم اندازه و فونت اعداد 
\newcommand{\Niloofar} {\settextfont[Scale=1.2]{XB Niloofar}}
\newcommand{\nastaliqh} {\fontspec[Scale=2]{IranNastaliq}} 
\newcommand{\nas} {\fontspec[Scale=1]{IranNastaliq}}
%\setmathsfdigitfont[Scale=1]{XB Niloofar}
\onehalfspacing
\setcounter{secnumdepth}{5}
\setcounter{tocdepth}{5} % دستوراتی برای فراهم شدن زیربخش و زیرپاراگراف، تو رفتگیهای بشتر در فصلها و زیر فصلها
\newcommand{\setpages}{\newpage \pagestyle{fancy}\cfoot{}\lhead{\thepage}\baselineskip=.7cm \pagenumbering{arabic}}
\headheight=16pt
% در مورد تقدم و تاخر وارد کردن بسته ها تنها باید به چند نکته دقت کرد:
% الف) بسته xepersian حتما حتما باید آخرین بسته ای باشد که فراخوانی می شود
% ب) بسته hyperref جزو آخرین بسته هایی باید باشد که فراخوانی می شود.
% ج) بسته glossaries حتما باید بعد از hyperref فراخوانی شود. 
%%************************توضیحاتی درباره بسته ها**************************************************
% بسته ای برای قرار گرفتن صفحات اول در فهرست tocbibind
%بسته‌ای برای ظاهر شدن «مراجع» و «نمایه» در فهرست مطالب fancyhdr

%این بسته جهت تعیین سایز کادر صفحه مورد استفاده قرار گرفته است. geometry 
% بسته ای برای محیط جدول با خواصی مخصوص tabu
%بسته ای برای جدول رنگی colortbl
%بسته ای برای محیط جدول برای دستورهای چند سطری multirow
% بسته ای برای شماره گذاری در لیست با سبک های متفاوت enumerate
% بسته ای برای رنگی کردن لینکها و رفرنس های موجود در متن hyperref
%این بسته جهت تغییر در سربرگ ها استفاده شده است. framed
% بسته ای برای توانایی در چرخش نوشته ها rotating
% بسته ای برای محیط جدول با خواصی مخصوص tabu 
% بسته ای برای محیط جدول برای دستورهای چند سطری multirow
% بسته ای برای شماره گذاری با سبک های متفاوت enumerate
% بسته ای برای جدول رنگی colortbl 
% بسته ای برای قرار دادن برنامه های برنامه متلب در پایان نامه listings
% بسته‌ای برای رسم کادر fancyhdr
% بسته هایی برای نمادهای ریاضی amssymb,amsthm,amsfonts,amscd
%جهت شماره گذاری از یک زیرنویسها در هر صفحه zref-perpage
%بسته زی پرشین برای تایپ فارسی لازم است که باید اخرین بسته فراخوانی شده باشد. xepersian
% با استفاده از این بسته قادر به فارسی نوشتن در لاتک هستید. بنابراین زی پرشین فقط یک بسته در لاتک می‌باشد.
%%% تغییر کتاب نامه به منابع و مآخذ
\def\bibname{منابع و مآخذ}
%% جایگزین کردن برهان بجای اثبات
\def\proofname{\textbf{برهان}}
\def\listfigurename{فهرست شکل‌ها}
\def\listtablename{فهرست جدول‌ها}
\def\listalgorithmname{فهرست الگوریتم‌ها}
\def\listofalgorithmss{\listofalgorithms\addcontentsline{toc}{chapter}{\listalgorithmname}}
\newcommand{\norm}[1]{\left\|{#1}\right\|_2}
\newcommand{\normf}[1]{\left\|{#1}\right\|_F}
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%\newtheorem{theorem}{Definition}[section]
\newtheorem{theorem}{قضیه}[chapter]
\newtheorem{lemma}[theorem]{لم}
\newtheorem{proposition}[theorem]{گزاره}
\newtheorem{corollary}[theorem]{نتیجه}
\newtheorem{conjecture}[theorem]{حدس} 
\theoremstyle{definition}
\newtheorem{definition}[theorem]{تعریف}
\newtheorem{remark}[theorem]{تبصره}
\newtheorem{note}[theorem]{نکته}
\newtheorem{example}[theorem]{مثال} 

%\numberwithin{algorithm}{chapter}
%\numberwithin{figure}{chapter}
%\numberwithin{equation}{chapter}
%\numberwithin{table}{chapter}

\lstdefinestyle{matlabstyle}{
	language=Matlab,
	frame=trBL, backgroundcolor=\color{gray!4},
	basicstyle=\small\ttfamily,
	framexleftmargin=5mm,
	%numbers=none,
	numbers=left, numberstyle=\tiny, numbersep=5pt,
	commentstyle=\color{red},
	showstringspaces=true,
	keywordstyle=\color{blue!85}\bfseries,
	showspaces=false,
	showtabs=false,
%	commentstyle=\textnormal,
}
%برای تغییر آ به الف در شمارنده‌ی harfi 
\makeatletter
\def\@harfi#1{\ifcase#1\or الف \or ب\or پ\or ت\or ث\or
	ج\or چ\or ح\or خ\or د\or ذ\or ر\or ز\or س\or ش\or ص\or ض\or ع\or غ\or
	ف\or ق\or ک\or گ\or ل\or م\or ن\or ه\or و\or ی\else\@ctrerr\fi}
\makeatother

% دستورات زیر برای نوشتن کد متلب:
% 
\lstset{
	%	% frame=trBL, backgroundcolor=\color{gray!4}, 
	%	numbers=none,
	%	numberstyle=\scriptsize,
	frameround=fttt,
	%	showspaces=false,showtabs=false, 
	%	framexleftmargin=1pt,
	%	framexrightmargin=2pt,
	%	framexbottommargin=2pt,
	%	showstringspaces=false ,
	%	breaklines=true,
	%	texcl=true,
	%	basicstyle=\footnotesize\ttfamily,
	%	keywordstyle=\bfseries\color{blue},
}
%%%====================================
%% 
\newlength\mylenprt
\newlength\mylenchp
\newlength\mylenapp
\renewcommand\cftpartpresnum{\partname\ }
\renewcommand\cftchappresnum{\chaptername\ }
\renewcommand\cftchapaftersnum{.}
\settowidth\mylenprt{\cftpartfont\cftpartpresnum\cftpartaftersnum}
\settowidth\mylenchp{\cftchapfont\cftchappresnum\cftchapaftersnum}
\settowidth\mylenapp{\cftchapfont\appendixname \cftchapaftersnum}
\addtolength\mylenprt{\cftpartnumwidth}
\addtolength\mylenchp{\cftchapnumwidth}
\addtolength\mylenapp{\cftchapnumwidth}
\setlength\cftpartnumwidth{\mylenprt}
\setlength\cftchapnumwidth{\mylenchp}

%%% =====================================================================================
%%% برای اجرا xindy بر روی فایل .tex و تولید واژه‌نامه‌ها و فهرست اختصارات و فهرست نمادها تعدادی دستور به صورت زیر تعریف شده است.‌ 
\def\titspace{\vspace{-22pt}}
\def\itemspace{\vspace{-9.5pt}}
\def\hhspace{\hspace{-1mm}}

\newglossarystyle{myAcron}{\renewenvironment{theglossary}{}{}\renewcommand*{\glsgroupskip}{\titspace}\renewcommand*{\glsgroupheading}[1]{\begin{LTR}\subsection*{\hhspace\glsgetgrouptitle{##1}}\end{LTR}}\renewcommand*{\glossentry}[2]{\begin{LTR}\begin{flushright}\itemspace\noindent\glsentrytext{##1} \space\dotfill\space \glsentryplural{##1}\end{flushright}\end{LTR}}}

\newglossarystyle{myEntoFa}{\renewenvironment{theglossary}{}{}\renewcommand*{\glsgroupskip}{\titspace}\renewcommand*{\glsgroupheading}[1]{\begin{LTR}\subsection*{\hhspace\glsgetgrouptitle{##1}}\end{LTR}}\renewcommand*{\glossentry}[2]{\begin{LTR}\begin{flushright}\itemspace\noindent\glsentryname{##1}\space\dotfill\space\glsentrytext{##1}\end{flushright}\end{LTR}}}


\newglossarystyle{mynemadha}{\renewenvironment{theglossary}{}{}\renewcommand*{\glsgroupskip}{\titspace}\renewcommand*{\glsgroupheading}[1]{\subsection*{\hhspace\glsgetgrouptitle{##1}}}\renewcommand*{\glossentry}[2]{\begin{LTR}\begin{flushright}\itemspace\noindent\glsentrydesc{##1}\space\dotfill\rl{\glsentryname{##1}}\end{flushright}\end{LTR}}} 

\newglossarystyle{myFaToEn}{\renewenvironment{theglossary}{}{}\renewcommand*{\glsgroupskip}{\titspace}\renewcommand*{\glsgroupheading}[1]{\subsection*{\hhspace\glsgetgrouptitle{##1}}}\renewcommand*{\glossentry}[2]{\begin{flushleft}\itemspace\noindent\glsentryname{##1}\space\dotfill\space\glsentrytext{##1}\end{flushleft}}}

\newglossarystyle{mywordlistfa}{\renewenvironment{theglossary}{}{}\renewcommand*{\glsgroupskip}{\titspace}\renewcommand*{\glsgroupheading}[1]{\subsection*{\hhspace\glsgetgrouptitle{##1}}} \renewcommand*{\glossentry}[2]{\begin{flushright} \itemspace\noindent\glsentryname{##1}\space\glstarget{}{##2}\end{flushright}}}

\newglossarystyle{mywordlisten}{\renewenvironment{theglossary}{}{}\renewcommand*{\glsgroupskip}{\titspace}\renewcommand*{\glsgroupheading}[1]{\begin{LTR}\subsection*{\hhspace\glsgetgrouptitle{##1}}\end{LTR}}\renewcommand*{\glossentry}[2]{\begin{LTR}\begin{flushleft}\itemspace\noindent\glsentryname{##1}\space\glstarget{}{##2}\end{flushleft}\end{LTR}}}



\newglossary[glg]{english}{gls}{glo}{\vspace{-.5cm}\begin{center}\rl{واژه‌نامه انگلیسی به فارسی}\end{center}}
\newglossary[blg]{persian}{bls}{blo}{\vspace{-.5cm}\begin{center}واژه‌نامه فارسی به انگلیسی\end{center}}
\newglossary[nlg]{nemad}{nls}{nlo}{\vspace{-.5cm}\begin{center}نمادهای اختصاری\end{center}}
\newglossary[glg]{eword}{gls}{glo}{\vspace{.5cm}\begin{center}\rl{واژه‌یاب انگلیسی}\end{center} }
\newglossary[blg]{fword}{bls}{blo} {\vspace{.5cm}\begin{center}واژه‌‌یاب فارسی\end{center} }
\newglossary[alg]{acrony}{als}{alo}{\vspace{-.5cm}\begin{center}\rl{فهرست اختصارات} \end{center}}

\makeglossaries \glsdisablehyper 
\let\oldgls\gls \let\oldglspl\glspl\makeatletter 

\renewrobustcmd*{\gls}{\@ifstar\@msgls\@mgls}

\newcommand*{\@mgls}[1]{\oldgls{#1}\ifthenelse{\equal{\glsentrytype{#1}}{english}}{\glsuseri{f-#1}}
	{\ifthenelse{\equal{\glsentrytype{#1}}{acrony}}{\glsuseri{e-#1}\glsuseri{f-#1}}{}}} 

\newcommand*{\@msgls}[1]{\ifthenelse{\equal{\glsentrytype{#1}}{english}}{\glstext{#1}\glsuseri{f-#1}} {\ifthenelse{\equal{\glsentrytype{#1}}{acrony}}{\glsentrytext{#1}\glsuseri{e-#1}\glsuseri{f-#1}}{\glsentryname{#1}}}}

\renewrobustcmd*{\glspl}{\@ifstar\@msglspl\@mglspl}
\newcommand*{\@mglspl}[1]{\oldglspl{#1}\ifthenelse{\equal{\glsentrytype{#1}}{english}}{\glsuseri{f-#1}}{}} 
\newcommand*{\@msglspl}[1]{\ifthenelse{\equal{\glsentrytype{#1}}{english}}{\glsplural{#1}\glsuseri{f-#1}}{\glsentryplural{#1}}}

\newcommand{\glsuse}[1]{\ifthenelse{\equal{\glsentrytype{#1}}{english}}{\glsuseri{#1}\glsuseri{f-#1}}
	{\ifthenelse{\equal{\glsentrytype{#1}}{acrony}}{\glsuseri{#1}\glsuseri{e-#1}\glsuseri{f-#1}}{\glsuseri{#1}}}} 

\makeatother
\newglossaryentry{label}{name={name},description={description}}
\newcommand{\newword}[4]{\newglossaryentry{#1}{type={english},name=\lr{#2},plural=\rl{#4},text=\rl{#3},description={}} \newglossaryentry{f-#1}{type={persian},name=\rl{#3},text=\lr{#2},plural=\rl{#4},description={}}}

\newcommand{\newaccro}[4]{
	\newglossaryentry{e-#1}{type={english},name=\lr{#3},text=\rl{#4},plural={#4},description={}}
	\newglossaryentry{f-#1}{type={persian},name=\rl{#4},text=\lr{#3},plural={#3},description={}}
	\newglossaryentry{#1}{type={acrony},name=\lr{#3},text=\lr{#2},plural=\rl{#4},description={}}
}

\newcommand{\newnemad}[4]{\newglossaryentry{#1}{type={nemad},name=\rl{#3},text=\rl{#4},description={#2}}}

\defglsentryfmt[english]{\glsgenentryfmt\ifglsused{\glslabel}{}{\LTRfootnote{\glsentryname{\glslabel}}}}
\defglsentryfmt[acrony]{\ifglsused{\glslabel}{\glsentrytext{\glslabel}}
	{\rl{\glsentryplural{\glslabel}}\LTRfootnote{\glsentryname{\glslabel}} (\glsentrytext{\glslabel})}}

\defglsentryfmt[nemad]{\glsgenentryfmt}
\newcommand{\WordsEnglish}{\pagestyle{empty}\begin{latin}\twocolumn\LTRdblcol \let\appendix\relax\phantomsection\addcontentsline{toc}{chapter}{واژه‌یاب انگلیسی} \setglossarystyle{mywordlisten} \Oldprintglossary[type=eword]\onecolumn\end{latin}}
\newcommand{\setpageglossary}[5]{\pagestyle{empty}#1\let\appendix\relax\phantomsection\addcontentsline{toc}{chapter}{#2} #3\setglossarystyle{#4} \Oldprintglossary[type=#5] \onecolumn}

\let\Oldprintglossary\printglossary
\newcommand{\DictionaryFaToEn}{\setpageglossary{\onecolumn}{واژه‌نامه فارسی به انگلیسی}{\RTLdblcol}{myFaToEn}{persian}}
\newcommand{\Nemadha}{\setpageglossary{\onecolumn}{نمادهای اختصاری}{\RTLdblcol}{mynemadha}{nemad}}
\newcommand{\DictionaryEnToFa}{\setpageglossary{\onecolumn}{واژه‌نامه انگلیسی به فارسی}{\LTRdblcol}{myEntoFa}{english}}
%\newcommand{\enword}{\setpageglossary{\twocolumn}{واژه‌یاب انگلیسی}{\LTRdblcol}{mywordlisten}{eword}}
\newcommand{\abbreviation}{\setpageglossary{\onecolumn}{فهرست اختصارات}{\LTRdblcol}{myAcron}{acrony}}
\newcommand{\WordsFarsi}{\setpageglossary{\twocolumn}{واژه‌یاب فارسی}{\RTLdblcol}{mywordlistfa}{fword}}
%%===================================================================================
\usepackage{morewrites}
%%افزودن واژه در نمایه دستی
\newcommand\gloss[2]{ \begin{flushleft}\itemspace \noindent\rl{#2} \dotfill \lr{#1}\end{flushleft}} 
\newcommand\fagloss[2]{\begin{flushleft}\itemspace{\noindent\rl{#2} \dotfill \lr{#1}}\end{flushleft}}
\def\fahd#1{\begin{flushright}\hhspace\textbf{\large\rl{#1}}\end{flushright} }
\newcommand\engloss[2]{\begin{LTR}\begin{flushright}\itemspace{\noindent\lr{#1} \dotfill \rl{#2} }\end{flushright}\end{LTR}} 
\def\enhd#1{\begin{flushleft}\begin{LTR}\hhspace\textbf{\large\lr{#1}}\end{LTR}\end{flushleft}}
%%%================================================================================
\def\Degree#1{\def\degree{#1}}
\def\FaFaculty#1{\def\faFac{#1}} 
\def\EnFaculty#1{\def\enFac{#1}}
\def\FaDepartment#1{\def\faDep{#1}}
\def\EnDepartment#1{\def\enDep{#1}}
\def\FaSpecialization#1{\def\faspec{#1}}
\def\EnSpecialization#1{\def\enspec{#1}}
\def\FaStudent#1{\def\fastudent{#1}}
\def\EnStudent#1{\def\enstudent{#1}}
\def\FaTitle#1{\def\fatitle{#1}}
\def\EnTitle#1{\def\entitle{#1}}
\def\FaMajor#1{\def\famajor{#1}}
\def\EnMajor#1{\def\enmajor{#1}}
\def\FaDate#1{\def\faDate{#1}}
\def\EnDate#1{\def\enDate{#1}} 

\def\FaInterfirstReviewer#1{\def\fainterfirstreviewer{#1}}
\def\EnInterfirstReviewer#1{\def\eninterfirstreviewer{#1}}
\def\FaInterfirstReviewerRank#1{\def\fainterfirstreviewerRank{#1}}
\def\EnInterfirstReviewerRank#1{\def\eninterfirstreviewerRank{#1}}
\def\FaInterfirstReviewerUni#1{\def\fainterfirstreviewerUni{#1}}
\def\EnInterfirstReviewerUni#1{\def\eninterfirstreviewerUni{#1}}
\def\FaInterfirstReviewerSpec#1{\def\fainterfirstreviewerSpec{#1}}
\def\EnInterfirstReviewerSpec#1{\def\eninterfirstreviewerSpec{#1}}

\def\FaInterSecReviewer#1{\def\fainterSecreviewer{#1}}
\def\EnInterSecReviewer#1{\def\eninterSecreviewer{#1}}
\def\FaInterSecReviewerRank#1{\def\fainterSecreviewerRank{#1}}
\def\EnInterSecReviewerRank#1{\def\eninterSecreviewerRank{#1}}
\def\FaInterSecReviewerUni#1{\def\fainterSecreviewerUni{#1}}
\def\EnInterSecReviewerUni#1{\def\eninterSecreviewerUni{#1}}
\def\FaInterSecReviewerSpec#1{\def\fainterSecreviewerSpec{#1}}
\def\EnInterSecReviewerSpec#1{\def\eninterSecreviewerSpec{#1}}

\def\FaAdvisor#1{\def\faadvisor{#1}}
\def\EnAdvisor#1{\def\enadvisor{#1}}
\def\FaAdvisorRank#1{\def\faadvisorRank{#1}}
\def\EnAdvisorRank#1{\def\enadvisorRank{#1}}
\def\FaAdvisorUni#1{\def\faadvisorUni{#1}}
\def\EnAdvisorUni#1{\def\enadvisorUni{#1}}
\def\FaAdvisorSpec#1{\def\faadvisorSpec{#1}}
\def\EnAdvisorSpec#1{\def\enadvisorSpec{#1}}

\def\FaSecAdvisor#1{\def\faSecadvisor{#1}}
\def\EnSecAdvisor#1{\def\enSecadvisor{#1}}
\def\FaSecAdvisorRank#1{\def\faSecadvisorRank{#1}}
\def\EnSecAdvisorRank#1{\def\enSecadvisorRank{#1}}
\def\FaSecAdvisorUni#1{\def\faSecadvisorUni{#1}}
\def\EnSecAdvisorUni#1{\def\enSecadvisorUni{#1}}
\def\FaSecAdvisorSpec#1{\def\faSecadvisorSpec{#1}}
\def\EnSecAdvisorSpec#1{\def\enSecadvisorSpec{#1}}

\def\FaOuterfirstReviewer#1{\def\faouterfirstreviewer{#1}}
\def\EnOuterfirstReviewer#1{\def\enouterfirstreviewer{#1}}
\def\FaOuterfirstReviewerRank#1{\def\faouterfirstreviewerRank{#1}}
\def\EnOuterfirstReviewerRank#1{\def\enouterfirstreviewerRank{#1}}
\def\FaOuterfirstReviewerUni#1{\def\faouterfirstreviewerUni{#1}}
\def\EnOuterfirstReviewerUni#1{\def\enouterfirstreviewerUni{#1}}
\def\FaOuterfirstReviewerSpec#1{\def\faouterfirstreviewerSpec{#1}}
\def\EnOuterfirstReviewerSpec#1{\def\enouterfirstreviewerSpec{#1}}

\def\FaOuterSecReviewer#1{\def\faouterSecreviewer{#1}}
\def\EnOuterSecReviewer#1{\def\enouterSecreviewer{#1}}
\def\FaOuterSecReviewerRank#1{\def\faouterSecreviewerRank{#1}}
\def\EnOuterSecReviewerRank#1{\def\enouterSecreviewerRank{#1}}
\def\FaOuterSecReviewerUni#1{\def\faouterSecreviewerUni{#1}}
\def\EnOuterSecReviewerUni#1{\def\enouterSecreviewerUni{#1}}
\def\FaOuterSecReviewerSpec#1{\def\faouterSecreviewerSpec{#1}}
\def\EnOuterSecReviewerSpec#1{\def\enouterSecreviewerSpec{#1}}

\def\FaOuterReviewer#1{\def\faouterreviewer{#1}}
\def\EnOuterReviewer#1{\def\enouterreviewer{#1}}
\def\FaOuterReviewerRank#1{\def\faouterreviewerRank{#1}}
\def\EnOuterReviewerRank#1{\def\enouterreviewerRank{#1}}
\def\FaOuterReviewerUni#1{\def\faouterreviewerUni{#1}}
\def\EnOuterReviewerUni#1{\def\enouterreviewerUni{#1}}
\def\FaOuterReviewerSpec#1{\def\faouterreviewerSpec{#1}}
\def\EnOuterReviewerSpec#1{\def\enouterreviewerSpec{#1}}

\def\FaSecSupervisor#1{\def\faSecsupervisor{#1}}
\def\EnSecSupervisor#1{\def\enSecsupervisor{#1}}
\def\FaSecSupervisorRank#1{\def\faSecsupervisorRank{#1}}
\def\EnSecSupervisorRank#1{\def\enSecsupervisorRank{#1}}
\def\FaSecSupervisorUni#1{\def\faSecsupervisorUni{#1}}
\def\EnSecSupervisorUni#1{\def\enSecsupervisorUni{#1}}
\def\FaSecSupervisorSpec#1{\def\faSecsupervisorSpec{#1}}
\def\EnSecSupervisorSpec#1{\def\enSecsupervisorSpec{#1}}

\def\FaSupervisor#1{\def\fasupervisor{#1}}
\def\EnSupervisor#1{\def\ensupervisor{#1}}
\def\FaSupervisorRank#1{\def\fasupervisorRank{#1}}
\def\EnSupervisorRank#1{\def\ensupervisorRank{#1}}
\def\FaSupervisorUni#1{\def\fasupervisorUni{#1}}
\def\EnSupervisorUni#1{\def\ensupervisorUni{#1}}
\def\FaSupervisorSpec#1{\def\fasupervisorSpec{#1}}
\def\EnSupervisorSpec#1{\def\ensupervisorSpec{#1}}

\def\FaAgent#1{\def\faagent{#1}}
\def\EnAgent#1{\def\enagent{#1}}
\def\FaAgentRank#1{\def\faagentRank{#1}}
\def\EnAgentRank#1{\def\enagentRank{#1}}
\def\FaAgentUni#1{\def\faagentUni{#1}}
\def\EnAgentUni#1{\def\enagentUni{#1}}
\def\FaAgentSpec#1{\def\faagentSpec{#1}}
\def\EnAgentSpec#1{\def\enagentSpec{#1}}

\def\Statedef#1{\def\statedef{#1}}
\def\DefTime#1{\def\timedef{#1}}
\def\DefDate#1{\def\datedef{#1}}
\def\DefExactDetefa#1{\def\defexactdetefa{#1}}
\def\DefExactDeteen#1{\def\defexactdeteen{#1}}
\def\DefScore#1{\def\defscore{#1}} 
\def\DefGen#1{\def\gen{#1}}
\def\FaAbstract#1{\def\FaABstract{#1}}
\def\EnAbstract#1{\def\EnABstract{#1}}
\def\FaKeywords#1{\def\fakeywords{#1}}
\def\EnKeywords#1{\def\enkeywords{#1}}
\def\FaDef#1{\def\deffa{#1}}
\def\EnDef#1{\def\defen{#1}}
\def\FaEsal#1{\def\esalfa{#1}}
\def\EnEsal#1{\def\esalen{#1}}

%%===================================================================================
\def\ifxthnls#1#2#3{\ifx#1\undefined#3\else#2\fi}
\def\magresone{\vspace{-.4cm}{ دانشکده \faFac\\{\footnotesize گروه \faDep}}\\}
 
\def\magres{\vspace{-.4cm}{گروه \faDep\\
		{\footnotesize 			گرایش    			   \faspec  		   }}\\}
\def\magresen{\vspace{-.4cm}{% Factually of \enFac\\
		Department of \enDep\\	{\footnotesize Specialization in  \enspec }} \\}


% مقادیر زیر را در صورت تمایل و با توجه به قرار گرفتن آنها می‌توانید تغییر دهید. 
\def\fastudenttitle{ دانشجو }
\def\enstudenttitle{ Student }

\def\faStudent{\ifxthnls{\fastudent}{\fastudenttitle \vfil \textbf{\Large{\fastudent}} \vfil \vfil \vfil \vfil}{}}
\def\faSupervisor{\ifxthnls\faSecsupervisor{{اساتید راهنما} \vfil \textbf{\Large{\fasupervisor}} \vfil \textbf{\Large{\faSecsupervisor}}}{{استاد راهنما} \vfil \textbf{\Large{\fasupervisor}} }\vfil \vfil \vfil }
\def\faAdvisor{\ifxthnls\faadvisor{
		\ifxthnls \faSecadvisor{{اساتید مشاور} \vfil \textbf{\Large{\faadvisor}} \vfil \textbf{\Large{\faSecadvisor}} }{ {استاد مشاور} \vfil \textbf{\Large{\faadvisor}} } }{\ifxthnls \faSecadvisor{ {استاد مشاور} \vfil \textbf{\Large{\faSecadvisor}} }{}  }\vfil \vfil \vfil }

\def\enSupervisor{\ifxthnls\enSecsupervisor{Supervisors \vfil \textbf{\Large{\ensupervisor}} \vfil \textbf{\Large{\enSecsupervisor}}}{Supervisor \vfil \textbf{\Large{\ensupervisor}}  }\vfil \vfil \vfil}
\def\enAdvisor{\ifxthnls\enadvisor {\ifxthnls\enSecadvisor{Advisors\vfil \textbf{\Large{\enadvisor}}\vfil \textbf{\Large{\enSecadvisor}} }{ Advisor\vfil\textbf{\Large{\enadvisor}}} \vfil \vfil   }{}}


\def\Outerreviewer {\ifxthnls\faouterfirstreviewer{\ifxthnls\faouterSecreviewer{ داوران خارجی  \vfil \textbf{\Large \faouterfirstreviewer (از 
				\ifxthnls\faouterfirstreviewerUni{\faouterfirstreviewerUni}{})} \vfil\textbf{\Large \faouterSecreviewer (از 
				\ifxthnls\faouterSecreviewerUni{\faouterSecreviewerUni}{})} }{  داور خارجی  \vfil \textbf{\Large \faouterfirstreviewer (از 
				\ifxthnls\faouterfirstreviewerUni{\faouterfirstreviewerUni}{})}}\vfil \vfil   }{}}


 
\def\Interreviewer {\ifxthnls\fainterfirstreviewer{\ifxthnls\fainterSecreviewer{   داوران داخلی    \vfil \textbf{\Large \fainterfirstreviewer } \vfil\textbf{\Large \fainterSecreviewer}  }{   داور داخلی  \vfil \textbf{\Large \fainterfirstreviewer }}\vfil \vfil \vfil }{}}

\def\enStudent{\ifxthnls\enstudent{\enstudenttitle \vfil \textbf{\Large{\enstudent}} \vfil \vfil \vfil \vfil }{}}

\def\falevel{\ifxthnls\degree{\if\degree p{دکتری}\else\if\degree m{کارشناسی ارشد}\else\if \degree b{کارشناسی}\else{مقطع اشتباه است}\fi\fi\fi}{مقطع خود را کنید}}
\def\enlevel{\ifxthnls\degree{\if\degree p{Ph.D}\else\if\degree m{M.Sc}\else\if \degree b{B.Sc}\else{level is false}\fi\fi\fi}{Choose your degree}}
\def\gensfa{\ifxthnls\gen{\if\gen m{آقای}\else\if\gen f{خانم}\else{جنسیت اشتباه انتخاب است}\fi\fi}{جنسیت خود را کنید}}
\def\gensen{\ifxthnls\gen{\if\gen m{Mr}\else\if\gen f{Mrs}\else{جنسیت اشتباه انتخاب است}\fi\fi}{جنسیت خود را کنید}}
\def\fathesis{\ifxthnls\degree{\if\degree p{رساله}\else\if\degree m{پایان‌نامه}\else\if \degree b{پروژه}\else{مقطع اشتباه است}\fi\fi\fi}{مقطع خود را کنید}}
\def\enthesis{\ifxthnls\degree{\if\degree p{thesis}\else\if\degree m{dissertation}\else\if \degree b{project}\else{level is false}\fi\fi\fi}{مقطع خود را کنید}}

\def\enthesisSec{\ifxthnls\degree{\if\degree p{Thesis}\else\if\degree m{Dissertation}\else\if \degree b{Project}\else{level is false}\fi\fi\fi}{مقطع خود را کنید}}

\def\faDegre{\ifdim\defscore pt <10pt {\ldots}\ifdim\defscore pt <17pt {ضعیف}\else \ifdim\defscore pt <18  pt{متوسط} \else \ifdim\defscore pt <19 pt  {خوب}\else {عالی}   \fi  \fi \fi}
\def\faScore{\ifxthnls\defscore{\defscore}{\ldots}}
\def\faDegre{\ifxthnls\defscore{\ifdim\defscore pt <17pt {ضعیف}\else \ifdim\defscore pt <18  pt{متوسط} \else \ifdim\defscore pt <19 pt  خوب\else {عالی}   \fi  \fi \fi} {\ldots}}
\def\enDegre{\ifxthnls\defscore{\ifdim\defscore pt <17pt {poor}\else \ifdim\defscore pt <18  pt{middle} \else \ifdim\defscore pt <19 pt  good\else {excellent}   \fi  \fi \fi} {\ldots}}

\def\magfirstfa{\vspace{-.4cm}{ دانشکده \faFac\\
		\vspace{1cm}{\textbf{\Huge  \fathesis\,\falevel }}}\\}

\def\magfirsten{\vspace{-.4cm}{Factually of \enFac\\
		\vspace{1cm}{\textbf{\Huge   \enthesisSec~of \enlevel }}}\\}

\def\magfa{\vspace{-.4cm}{ دانشکده \faFac\\{\footnotesize گروه \faDep}}\\}

\def\magen{\vspace{-.4cm}{Factually of  \enFac \\ {\footnotesize 	Department of \faDep}}\\}

\def\magonvanfa{\vspace{-.4cm}{گروه \faDep\\
		{\footnotesize 			گرایش    			   \faspec  		   }}\\}
	
\def\magonvanen{\vspace{-.4cm}{% Factually of \enFac\\
		Department of \enDep\\	{\footnotesize Specialization in  \enspec }} \\}
	% جلد فارسی
	\def\JeldFarsi{
		\newpage
		\thispagestyle{empty}
		\begin{figure}[H] \vspace{-2cm}
			\centerline{\includegraphics[height=2.9cm,width=2.5cm]{resources/falogo}}
		\end{figure}
		\begin{center}
			\magfirstfa
			\vfil \vfil   \vfil
			\textbf{\huge{\fatitle}} 
			\vfil \vfil \vfil \vfil
			\faStudent
			\faSupervisor% \faSecSupervisor
			\faAdvisor% \faSecAdvisor
			\vfil \vfil \vfil \vfil \vfil \vfil
			\faDate
		\end{center} 
		\thispagestyle{empty}\newpage
		\begin{figure}[H] 
			\centerline{\includegraphics[height=.9\textheight,width=.9\textwidth]{resources/besm.jpg}}
		\end{figure}
		\thispagestyle{empty}
		\newpage
		\thispagestyle{empty}
		\begin{figure}[H] \vspace{-2cm}
			\centerline{\includegraphics[height=2.9cm,width=2.5cm]{resources/falogo}}
		\end{figure}
		\begin{center}
			\magonvanfa
			\vfil \vfil \vfil \vfil
			\textbf{\huge{\fatitle}} 
			\vfil \vfil \vfil \vfil
			\faStudent
			\faSupervisor% \faSecSupervisor
			\faAdvisor% \faSecAdvisor
			\vfil \vfil \vfil \vfil \vfil \vfil
			\faDate
		\end{center} 
	}

%% قسمت جلد انگلیسی
\def\JeldEnglish{ 
	\newpage
	\thispagestyle{empty}
	\begin{figure}[H] \vspace{-2cm}
		\centerline{\includegraphics[height=2.85cm,width=2.8cm]{resources/enlogo}}
	\end{figure}
	\begin{latin}
		\setlatintextfont[Scale=.75,ExternalLocation,BoldFont={lmroman10-bold}]{lmroman10-regular}
		\begin{center}
			\magonvanen
			\vfil \vfil \vfil \vfil \vfil
			
			\textbf{\huge{\entitle}}
			\vfil \vfil \vfil \vfil\vfil
			
			\enStudent 
			
			\enSupervisor
			
			\enAdvisor
			
			\vfil \vfil \vfil \vfil \vfil \vfil
			\lr{\enDate}
		\end{center} 
	\end{latin} 
\newpage
\thispagestyle{empty}
\begin{figure}[H] \vspace{-2cm}
	\centerline{\includegraphics[height=2.85cm,width=2.8cm]{resources/enlogo}}
\end{figure}
\begin{latin}
	\setlatintextfont[Scale=.75,ExternalLocation,BoldFont={lmroman10-bold}]{lmroman10-regular}
	\begin{center}
		\magfirsten
		\vfil \vfil \vfil  
		
		\textbf{\huge{\entitle}}
		\vfil \vfil \vfil \vfil\vfil
		
		\enStudent 
		
		\enSupervisor
		
		\enAdvisor
		
		\vfil \vfil \vfil \vfil \vfil \vfil
		\lr{\enDate}
	\end{center} 
\end{latin} 
}

% قسمت چکیده انگلیسی
\def\AbstractEnglish{\newpage\baselineskip=.7cm\thispagestyle{empty}\vspace{1cm}\begin{latin}
		{\normalsize\textbf{Abstract}}\\\vspace{-.5cm}
		\begin{center}\shadowbox{\begin{varwidth}{.9\textwidth}\centering
					{\textbf{\large\\\vspace{4mm}\entitle}}\\\vspace{.5cm}{\normalsize\enstudent\vspace{5mm}\\\vspace{2mm}}
		\end{varwidth}}\end{center}\vspace{2cm}\EnABstract
		\vskip 2cm\noindent\textbf{Keywords}: \textit{\small\enkeywords}\end{latin}}
% قسمت چکیده فارسی
\def\AbstractFarsi{
	\baselineskip=.7cm \addcontentsline{toc}{chapter}{چکیده}
	{ \normalsize\textbf {چکیده}}\\\vspace{-.5cm} 
	\begin{center}\shadowbox{\begin{varwidth}{.9\textwidth}\centering
				{\textbf{\Large\\\vspace{4mm}\fatitle}}\\\vspace{.5cm}{\normalsize\fastudent \vspace{5mm} \\\vspace{2mm}}\end{varwidth}}\end{center}\vskip 2cm\FaABstract 
	\vskip 2cm \noindent \textbf{کلید واژه}: \textit{\small \fakeywords}
}
% اطلاعیه جلسه دفاع
\def\Ettelaeie{\thispagestyle{empty}\newpage\thispagestyle{empty}\begin{figure}[H] \vspace{-2cm} \centerline{\includegraphics[height=2.9cm,width=2.5cm]{resources/falogo}}\end{figure}\begin{center}\magresone\vfil \vspace{1cm}\textbf{\large جلسه دفاع از \fathesis\,\falevel } \vfil \vfil \vfil {\large{ عنوان\ \fathesis}}\vfil\textbf{\LARGE{\fatitle}} \vfil \vfil \vfil \vfil\faStudent\faSupervisor\faAdvisor\Outerreviewer\Interreviewer\vfil\vfil\begin{center}\scalebox{1}{\shadowbox{\begin{varwidth}{\textwidth}\centering{{\vfil \vfil \vfil \vfil \vfil \vfil \textbf{\large تاریخ برگزاری: \ifxthnls\datedef { \datedef}{}\ \ \ifxthnls\defexactdetefa {\defexactdetefa}{}\ \ \ ساعت \ifxthnls\timedef {\timedef}{}}\vfil\textbf{\large مکان برگزاری: \ifxthnls\statedef{\statedef}{}} }}\end{varwidth}}}\end{center}\end{center}}

\newcounter{nsupfa}
\newcounter{nadvfa} 
\newcounter{nrevfa} 
\newcounter{nsupen}
\newcounter{nadven} 
\newcounter{nreven} 
\def\toptab{2}
\newcounter{vtab1}
\newcounter{vtab2}
\newcounter{vtab3}
\newcounter{vtab4}
\newcounter{cent}
\setcounter{vtab1}{34}
\setcounter{vtab2}{\toptab}
\setcounter{vtab3}{15}
%\setcounter{vtab4}{\toptab}
\def \DefenceFarsi {{\ifxthnls \deffa{\newpage \thispagestyle{empty}\begin{figure}[H] \centerline{\includegraphics[height=.9\textheight,width=1\textwidth]
				{resources/\deffa}} \end{figure}}
	{\ifxthnls{\fasupervisor}{\addtocounter{nsupfa}{1}}{}
		\ifxthnls{\faSecsupervisor}{\addtocounter{nsupfa}{1}}{}
		\ifxthnls{\faadvisor}{\addtocounter{nadvfa} {1}}{}
		\ifxthnls{\faSecadvisor}{\addtocounter{nadvfa} {1}}{}
		\ifxthnls{\faouterfirstreviewer}{\addtocounter{nrevfa} {1}}{}
		\ifxthnls{\faouterSecreviewer}{\addtocounter{nrevfa} {1}}{}
		\ifxthnls{\fainterfirstreviewer}{\addtocounter{nrevfa} {1}}{}
		\ifxthnls{\fainterSecreviewer}{\addtocounter{nrevfa} {1}}{}
		\def\namsupfa{\ifnum \arabic{nsupfa}>1{اساتید راهنما}\else{استاد راهنما}\fi}
		\def\namadvfa{\ifnum \arabic{nadvfa}>1{اساتید مشاور}\else{استاد مشاور}\fi}
		\def\namrevfa{\ifnum \arabic{nrevfa}>1{داوران}\else{داور}\fi}
		\setcounter{vtab3}{\arabic{nsupfa}+\arabic{nadvfa}+\arabic{nrevfa}}
		\setcounter{vtab4}{\toptab*\arabic{vtab3}+\toptab} 
		\addtocounter{vtab1}{ -\arabic{vtab4}}
		\addtocounter{vtab2}{ -\arabic{vtab1}} %\addtocounter{vtab2}{ -\arabic{vtab1}} 
		\settextfont[Scale=.85]{XB Niloofar} \newpage   \thispagestyle{empty} 
		\begin{figure}[H] \vspace{-3cm}
			\centerline{\includegraphics[height=2.3cm,width=2cm]{resources/falogo}}
		\end{figure}\vspace*{-9mm}
		\begin{center}
			\textbf{بسمه تعالی}
			\\[0cm]
			\textbf{صورتجلسه دفاع از \fathesis~\falevel}\\
		\end{center}
		جلسه دفاع از  
		\fathesis~\falevel~\gensfa~\textbf{\fastudent}\ 
		در رشته \textbf{\famajor}  
		گرایش  	\textbf{\faspec} 
		با عنوان:	
				\begin{center}
					\begin{varwidth}{\textwidth}
						\settextfont[Scale=.92]{XB Niloofar} \centering
						\textbf{\fatitle}\end{varwidth}
				\end{center}
		به ارزش\textbf{\if \degree p{\scalebox{.9}{20}} \else \if \degree m {\scalebox{.9}{12}  }  \else \fi \fi
			واحد} 
		که در ساعت 
		{\ifxthnls\timedef{\scalebox{.9}{$ \mathbf{\timedef} $}}{}}
		روز 
		\ifxthnls\datedef {\datedef} {}
		مورخ 
		\ifxthnls\defexactdetefa{\scalebox{.9}{$ \mathbf{\defexactdetefa} $}}{}
		در محل دانشکده
		\textbf{\ifxthnls\faFac{\faFac}{}}
		دانشگاه گیلان برگزار شد. هیأت داوران پس از بررسی، نتیجه را به شرح زیر اعلام می‌دارند: \vspace{2mm} \\ \ding{114} \fathesis\ با نمره $\cdots $ و با امتیاز عالی \ding{114}، بسیار خوب \ding{114}، خوب \ding{114}، قابل قبول \ding{114} مورد تایید قرار گرفت. \vspace{2mm}\\ \ding{114} \fathesis\ در وضع فعلی با اصلاحات جزیی و نمره $\cdots$ و با امتیاز عالی 
		\ding{114}، بسیار خوب \ding{114}، خوب \ding{114}، قابل قبول \ding{114} پذیرفته شد.\vspace{2mm}\\ \ding{114} \fathesis\ به شکل فعلی، مورد تأیید قرار نگرفت و پیشنهاد شد $\cdots\cdots\cdots$
		\begin{table}[!bh]
			{\small 
				\begin{center}
					\tabulinesep =^4 pt _\arabic{vtab1}pt
					\begin{tabu}{|[2pt]c|[2pt]X[1.34,p,c]|[2pt]c|[2pt]X[2.75,p,c]|[2pt]X[2,p,c]|[2pt]}
						\tabucline[2pt]-\vspace{\arabic{vtab2}pt}
						\textbf{\footnotesize اعضاء هیأت داوران}&\textbf{\footnotesize مرتبه‌دانشگاهی}&\textbf{\footnotesize تخصص}&
						\textbf{\footnotesize محل کار اعضاء هیأت داوران}&\textbf{\footnotesize امضاء}\\
						\ifnum\arabic{nsupfa}>0\tabucline[2pt]-\vspace{\arabic{vtab2}pt}\namsupfa \setcounter{nsupfa}{0}&&&&\vspace{-\arabic{vtab4}pt}\\ 
						\ifxthnls{\fasupervisor}{\addtocounter{nsupfa}{1}\textbf{\arabic{nsupfa}-\fasupervisor}&\fasupervisorRank&\fasupervisorSpec&\fasupervisorUni&\\}{}
						\ifxthnls{\faSecsupervisor}{\addtocounter{nsupfa}{1}\textbf{\arabic{nsupfa}-\faSecsupervisor}&\faSecsupervisorRank&\faSecsupervisorSpec&\faSecsupervisorUni&\\}{}
						\else\fi
						\ifnum\arabic{nadvfa}>0\tabucline[2pt]-\vspace{\arabic{vtab2}pt}
						\namadvfa\setcounter{nadvfa}{0}&&&&\vspace{-\arabic{vtab4}pt} \\ 
						\ifxthnls{\faadvisor}{\addtocounter{nadvfa}{1}\textbf{\arabic{nadvfa}-\faadvisor}&\faadvisorRank&\faadvisorSpec&\faadvisorUni&\\}{}
						\ifxthnls{\faSecadvisor}{\addtocounter{nadvfa} {1} \textbf{\arabic{nadvfa}-\faSecadvisor}& \faSecadvisorRank&\faSecadvisorSpec&\faSecadvisorUni&\\}{}
						\else\fi
						\ifnum\arabic{nrevfa}>0\tabucline[2pt]-\vspace{\arabic{vtab2}pt}
						\namrevfa\setcounter{nrevfa}{0}&&&&\vspace{-\arabic{vtab4}pt}\\
						\ifxthnls{\faouterfirstreviewer}{\addtocounter{nrevfa} {1} \textbf{\arabic{nrevfa}-\faouterfirstreviewer} &\faouterfirstreviewerRank&\faouterfirstreviewerSpec&\faouterfirstreviewerUni&\\}{}
						\ifxthnls{\faouterSecreviewer}{\addtocounter{nrevfa} {1} \textbf{\arabic{nrevfa}-\faouterSecreviewer} &\faouterSecreviewerRank&\faouterSecreviewerSpec&\faouterSecreviewerUni&\\}{}
						\ifxthnls{\fainterfirstreviewer}{\addtocounter{nrevfa} {1} \textbf{\arabic{nrevfa}-\fainterfirstreviewer} &\fainterfirstreviewerRank&\fainterfirstreviewerSpec&\fainterfirstreviewerUni&\\}{}
						\ifxthnls{\fainterSecreviewer}{\addtocounter{nrevfa} {1} \textbf{\arabic{nrevfa}-\fainterSecreviewer} &\fainterSecreviewerRank&\fainterSecreviewerSpec&\fainterSecreviewerUni&\\}{}
						\else\fi
						\tabucline[2pt]-
					\end{tabu}\vspace{.25cm}
					\tabulinesep= ^5 pt _\arabic{vtab1}pt
					\begin{tabu}{|[2pt]c|[2pt]X[.5,p,c]|[2pt]X[.75,p,c]|[2pt]X[.5,p,c]|[2pt]}
						\tabucline[2pt]-\vspace{\arabic{vtab2}pt}
						\textbf{\footnotesize
							نماینده تحصیلات تکمیلی\RTLfootnote{}
						}
						&\textbf{\footnotesize مرتبه دانشگاهی}&\textbf{\footnotesize گروه آموزشی/ پژوهشی}&
						\textbf{\footnotesize امضاء} \\ \tabucline[2pt]-\vspace{\arabic{vtab2}pt} &&& \\
						\ifx\faagent\undefined&&&\else\textbf{\faagent}&\faagentRank&\faagentSpec&\fi\\\tabucline[2pt]-
					\end{tabu}
			\end{center}}
		\end{table}
		\footnoterule
		{\scriptsize\textcolor{blue}{$^1$}\vspace{-3mm}
			نسخه اصل از صورتجلسه توسط نماینده تحصیلات تکمیلی تنطیم و به مدیر گروه تسلیم شود. یک نسـخه در گـروه آموزشـی، یـک نسـخه در آمـوزش دانشکده، یک نسخه در پرونده دانشجو نگهداري و یک نسخه نیز به دانشجو تحویل داده شود.} 
}}}


%برگه جلسه دفاع انگلیسی
\newcounter{vtab5}
\newcounter{vtab6}
\newcounter{vtab7}
\newcounter{vtab8}
\def \toptaben{4}
\setcounter{vtab5}{45}
\setcounter{vtab6}{10}
\setcounter{vtab7}{2}
\def \DefenceEnglish {{\ifxthnls \defen{\newpage\thispagestyle{empty}\begin{figure}[H]\centerline{\includegraphics[height=.9\textheight,width=1\textwidth]{resources/\defen}} \end{figure}}
	{\ifxthnls{\ensupervisor}{\addtocounter{nsupen}{1}}{}
		\ifxthnls{\enSecsupervisor}{\addtocounter{nsupen}{1}}{}
		\ifxthnls{\enadvisor}{\addtocounter{nadven} {1}}{}
		\ifxthnls{\enSecadvisor}{\addtocounter{nadven} {1}}{}
		\ifxthnls{\enouterfirstreviewer}{\addtocounter{nreven} {1}}{}
		\ifxthnls{\enouterSecreviewer}{\addtocounter{nreven} {1}}{}
		\ifxthnls{\eninterfirstreviewer}{\addtocounter{nreven} {1}}{}
		\ifxthnls{\eninterSecreviewer}{\addtocounter{nreven} {1}}{}
		\def\namsupen{\ifnum \arabic{nsupen}>1{Major Advisors}\else{Major Advisor}\fi}
		\def\namadven{\ifnum \arabic{nadven}>1{Minor Advisors}\else{Minor Advisor}\fi}
		\def\namreven{\ifnum \arabic{nreven}>1{Examiners}\else{Examiner}\fi} 
		\setcounter{vtab7}{\arabic{nsupen}+\arabic{nadven}+\arabic{nreven}}
		\setcounter{vtab8}{\toptaben*\arabic{vtab7}+\toptaben} 
		\addtocounter{vtab5}{ -\arabic{vtab8}}
		\addtocounter{vtab6}{ -\arabic{vtab5}}  
		\newpage \thispagestyle{empty}
		\begin{latin}
			{\setlatintextfont[Scale=.6]{XB Niloofar} 
				\begin{figure}[H] \vspace{-3cm}
					\centerline{\includegraphics[height=2.35cm,width=2.3cm]{resources/enlogo}}
				\end{figure}
				\begin{center}
					\vspace{-.8cm} 
					\textbf{In The Name of God}
					\\\vspace{-.1cm}
					\textbf{Proceeding for \enlevel~\enthesis}
			\end{center}}
			{\setlatintextfont[Scale=.9]{XB Niloofar} 
				Defence session for granting
				\enlevel\ \enthesis\ on award to\ \textbf{\gensen\ \enstudent}\
				majoring in \textbf{\enmajor}\ 
				with minor in \textbf{\enspec} title of \enthesis 
					\begin{center}
					\begin{varwidth}{\textwidth}
						\setlatintextfont[Scale=.95]{XB Niloofar}   \centering
						\textbf{\entitle}\end{varwidth}
				\end{center}
				in Guilan province with \if \degree p{\bf 20} \else \if \degree m {\bf 12} \else \fi \fi hours credit, held on \ifxthnls\defexactdeteen{{\bf \defexactdeteen}}{} 
				at \textbf{\ifx\timedef\undefined \else{\timedef}\fi} in Faculty of  {\bf \enFac}, University of Guilan. The juries announced the following decision:
				\vspace{1mm}\\ \ding{114} The \enthesis\ is accepted with score $\cdots $ of 20 ranged as Excellent \ding{114}, Very good \ding{114}, Good \ding{114}, Acceptable \ding{114}. \vspace{1mm}\\ \ding{114} The \enthesis\ is acceptable with minor corrections with score $\cdots $ of 20 ranged as Excellent \ding{114}, 
				Very good \ding{114}, Good \ding{114}, Acceptable \ding{114}. \vspace{1mm}\\ \ding{114} The \enthesis\ with present status did not accepted and suggested that $\cdots\cdots\cdots$ \renewcommand{\arraystretch}{.9}
				\begin{table}[!bh]
					{\scriptsize
						\begin{center}
							\tabulinesep =^3pt _\arabic{vtab5}pt \begin{tabu}{|[2pt]c|[2pt]X[.5,p,c]|[2pt]X[.9,p,c]|[2pt]X[.85,p,c]|[2pt]X[.8,p,c]|[2pt]}
								\tabucline[2pt]-\vspace{\arabic{vtab6}pt}
								\textbf{Juries’ members} &\textbf{Ranks}&\textbf{Specialization}&
								\textbf{Affiliation} & \textbf{Signature} \\ 
								\ifnum\arabic{nsupen}>0\tabucline[2pt]-\vspace{\arabic{vtab6}pt}\namsupen \setcounter{nsupen}{0}&&&&\vspace{-\arabic{vtab8}pt}\\ 
								\ifxthnls{\ensupervisor}{\addtocounter{nsupen}{1}\textbf{\arabic{nsupen}-\ensupervisor}&\ensupervisorRank&\ensupervisorSpec&\ensupervisorUni&\\}{}
								\ifxthnls{\enSecsupervisor}{\addtocounter{nsupen}{1}\textbf{\arabic{nsupen}-\enSecsupervisor}&\enSecsupervisorRank&\enSecsupervisorSpec&\enSecsupervisorUni&\\}{}
								\else\fi
								\ifnum\arabic{nadven}>0\tabucline[2pt]-\vspace{\arabic{vtab6}pt}
								\namadven\setcounter{nadven}{0}&&&&\vspace{-\arabic{vtab8}pt} \\ 
								\ifxthnls{\enadvisor}{ \addtocounter{nadven}{1}\textbf{\arabic{nadven}-\enadvisor}&\enadvisorRank&\enadvisorSpec&\enadvisorUni&\\}{}
								\ifxthnls{\enSecadvisor}{\addtocounter{nadven} {1} \textbf{\arabic{nadven}-\enSecadvisor}& \enSecadvisorRank&\enSecadvisorSpec&\enSecadvisorUni&\\}{}
								\else\fi
								\ifnum\arabic{nreven}>0\tabucline[2pt]-\vspace{\arabic{vtab6}pt}
								\namreven\setcounter{nreven}{0}&&&&\vspace{-\arabic{vtab8}pt}\\
								\ifxthnls{\enouterfirstreviewer}{\addtocounter{nreven} {1} \textbf{\arabic{nreven}-\enouterfirstreviewer} &\enouterfirstreviewerRank&\enouterfirstreviewerSpec&\enouterfirstreviewerUni&\\}{}
								\ifxthnls{\enouterSecreviewer}{\addtocounter{nreven} {1} \textbf{\arabic{nreven}-\enouterSecreviewer} &\enouterSecreviewerRank&\enouterSecreviewerSpec&\enouterSecreviewerUni&\\}{}
								\ifxthnls{\eninterfirstreviewer}{\addtocounter{nreven} {1} \textbf{\arabic{nreven}-\eninterfirstreviewer} &\eninterfirstreviewerRank&\eninterfirstreviewerSpec&\eninterfirstreviewerUni&\\}{}
								\ifxthnls{\eninterSecreviewer}{\addtocounter{nreven} {1} \textbf{\arabic{nreven}-\eninterSecreviewer} &\eninterSecreviewerRank&\eninterSecreviewerSpec&\eninterSecreviewerUni&\\}{}
								\else\fi
								\tabucline[2pt]-
							\end{tabu}\vspace{.25cm}
							\tabulinesep= ^3 pt _\arabic{vtab5}pt
							\begin{tabu}{|[2pt]c|[2pt]X[.5,p,c]|[2pt]X[.5,p,c]|[2pt]X[.5,p,c]|[2pt]} 
								\tabucline[2pt]-\vspace{\arabic{vtab6}pt}
								\textbf{
									Representative of College
									Graduate Office\LTRfootnote{ }
								}
								&\textbf{Rank}&\textbf{Affiliation }&
								\textbf{Signature} \\ \tabucline[2pt]-\vspace{\arabic{vtab6}pt} &&& \\
								\ifx\enagent\undefined&&&\else\textbf{\enagent}&\enagentRank&\enagentSpec&\fi\  \\ \tabucline[2pt]-
							\end{tabu}
					\end{center}}
				\end{table}\vspace{-3mm}
				\footnoterule
				{\scriptsize\textcolor{blue}{$^1$} \vspace{-3mm} After completing of all documents four copies of the proceeding have to be submitted and handed to the
					Director of College Graduate Office. From four copies, one will be kept in the student department, one in \vspace{-3mm}Graduate Office, one in the file of student and the last hands to the student.}}
		\end{latin} 
}}}
%برگه اصالت فارسی
\def \EsalatFarsi {\ifx\esalfa \undefined \newpage \thispagestyle{empty}
	\begin{figure}[H] \vspace{-3cm}
		\centerline{\includegraphics[height=2.3cm,width=2cm]{resources/falogo}}
	\end{figure}\vspace*{-.5cm}
	\begin{center}
		\textbf{حوزه معاونت آموزشی و تحصیلات تکمیلی دانشگاه}
		\\[.3cm]
		\textbf{تعهدنامه اصالت \fathesis }
	\end{center}
	
	اینجانب	\fastudent\ دانش‌آموخته مقطع 	\falevel\ در رشته	\famajor\ که در تاریخ 	\defexactdetefa\ از \fathesis\ خود با عنوان 	\textit{\fatitle\ }با کسب نمره
	{ $  {\faScore}  $}  
	و درجه 	{\faDegre} دفاع نموده‌ام، اظهار می‌کنم که:
	\begin{enumerate}
		\item
		این \fathesis\ حاصل تحقیق و پژوهش اینجانب بوده و در مواردی که از دستاوردهای علمی و پژوهشی دیگران (اعم از کتاب، مقاله و
		\dots ) استفاده کرده‌ام، مطابق ضوابط موجود، نام منبع مورد استفاده و سایر مشخصات آن را در فهرست منابع ذکر و درج نموده‌ام.
		\item
		این \fathesis\ پیشتر برای دریافت هیچ مدرک تحصیلی (هم سطح، پایین‌تر یا بالاتر) در سایر دانشگاه‌ها و مؤسسات آموزش عالی داخلی و خارجی ارائه نشده‌است.
		
		\hspace{-1cm}
		ضمنا متعهد می‌شوم:
		\item
		چنانچه بعد از دانش‌آموختگی، قصد استفاده و هر گونه بهره‌برداری اعم از چاپ مقاله، کتاب، ثبت اختراع و \dots  \ از این \fathesis\ را داشته باشم، از استاد محترم راهنما و گروه آموزشی مربوطه مجوزهای لازم را اخذ نمایم. 
		\item
		چنانچه در هر مقطع زمانی خلاف موارد فوق ثابت شود، عواقب ناشی از آن را بپذیرم و دانشگاه گیلان مجاز است با اینجانب مطابق ضوابط و مقررات رفتار نموده و در صورت ابطال مدرک تحصیلی‌ام، هیچگونه ادعایی نخواهم داشت.
	\end{enumerate}
	\vspace*{.5cm}
	\begin{center}\hspace{5cm}
		نام و نام خانوادگی:
		
		\vspace*{.3cm}\hspace{5cm}
		تاریخ و امضاء:
	\end{center}
	\newpage
	\else {\newpage \thispagestyle{empty}\begin{figure}[H] \centerline{\includegraphics[height=.9\textheight,width=1\textwidth]{resources/\esalfa}} \end{figure}}\fi}
%برگه اصالت انگلیسی
\def \EsalatEnglish {\ifx\esalen\undefined 
	\newpage
	\thispagestyle{empty}
	\begin{latin}
		\begin{figure}[H] \vspace{-3cm}
			\centerline{\includegraphics[height=2.35cm,width=2.3cm]{resources/enlogo}}
		\end{figure}
		\begin{center}
			\vspace{-.4cm} 
			\textbf{Office of Vice President for Academic and Graduate Affair}\\[.3cm]
			\textbf{Declaration of the \enthesis\, originality}
		\end{center}
		Hereby, I declare that this \enthesis\ entitled \textit {\entitle} which has been defended for a \enlevel\ degree in the filed \enmajor\ in \enDate,
		is a result of my own research. In the case when some other studies and/or publications have been 		used in the text are cited. 
		This \enthesis\ has not been submitted for any
		degree in any other institutions, inside or outside of Iran.
		I hereby undertake that, in the case of making any use from my \enthesis\ for
		publishing articles, books, patent registration, etc., the permission of my major
		advisor and department is necessary; otherwise, University of Guilan authorities
		have the right to take action against me based on rules and requirements, and
		in the case of canceling my degree, I have no right to claim.
		\vspace*{.5cm}
		\begin{center}\hspace{5cm}
			Full name:\\\hspace{5cm}
			\vspace*{.3cm}
			Signature and Date:
		\end{center}
	\end{latin}
	\else {\newpage \thispagestyle{empty}\begin{figure}[H] \centerline{\includegraphics[height=.9\textheight,width=1\textwidth]{resources/\esalen}} \end{figure}}\fi}
\definecolor{mycol}{rgb}{.1 .0 .5}
\lstset{language=TeX,
	% frame=trBL, backgroundcolor=\color{gray!4}, 
	%breakindent=0pt,
	%columns=[r]fixed,
	%flexiblecolumns=false,
	%keepspaces=true,
	%basewidth={2pt,10pt},
	%fancyvrb=false,
	%basewidth=1pt,
	%frameshape=yny,
	%linewidth=1 \textwidth,
	%columns= [c]fixed,
	numbers=none,
	numberstyle=\scriptsize,
	frameround=fttt,
	showspaces=false,showtabs=false, 
	% xleftmargin=6cm,
	% xrightmargin=6cm,
	framexleftmargin=1pt,
	framexrightmargin=2pt,
	framexbottommargin=2pt,
	showstringspaces=false ,
	breaklines=true,
	texcl=true,
	basicstyle=\footnotesize\ttfamily,
	keywordstyle=\bfseries\color{blue},
	stringstyle=\color{blue},
	commentstyle= \color{red},
	emph={\begin,\end,\documentclass}, emphstyle=\color{blue},
	emph={[2]document,cases,center,equation,align,thebibliography,enumerate,tabular,agorithmic,tabu},emphstyle={[2]\color{mycol}},
	emph={[3]\int,\sqrt,\frac,\item,\bibitem,\caption,\includegraphics,\scalebox,\multicolumn,\multirow},emphstyle={[3]\color{brown!90}},
	emph={[4]\label},emphstyle={[4]\color{green!99}},
	emph={[5]figure,table,algorithm,bibliographystyle,	bibliography}, emphstyle={[5]\color{brown!50}},
	emph={[6]newword,newaccro,newnemad},emphstyle={[6]\bfseries\color{blue}},
	emph={[7]\underline,\textit,\textsl,\textbf,\texttt,\textsc,\textsf,\sf,\sc,\it,\sl,\bf,\tt\emph,\mathbb,\mathit,\mathcal,\mathbf,\mathfrak,\mathrm,\mathsf,\mathtt,\frak,\tiny,\scriptsize,\footnotesize, \small,\normalsize,\large,\Large,\LARGE,\huge,\Huge,\HUGE,\def,\newcommand},emphstyle={[7]\bfseries\color{red}},
}